-- create procedure GetListReservationBookingManagerListView --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListReservationBookingManagerListView]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListReservationBookingManagerListView]
GO
CREATE PROCEDURE [dbo].[GetListReservationBookingManagerListView]
	@startTime datetime = null,
	@endTime datetime = null,
	@groupId int = null,
	@resourceIds nvarchar(max) = null,
	@locationIds nvarchar(max) = null,
	@organizerMail nvarchar(max) = null,
	@skip int = 0,
	@pageSize int = 50
AS
BEGIN
	-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Item from udfSplitStringV2(@resourceIds, ',')
-- split location ids list string into table
declare @locationIdsTbl table (id nvarchar(256))
insert into @locationIdsTbl
select Item from udfSplitStringV2(@locationIds, ',')
-- get all child resource is inprocess in booking manager
declare @childResources table(id int)
    insert into @childResources
    select cr.ChildResourceId from BookingManagerMessage bm
    inner join ChildResources cr on bm.ResourceId = cr.VirtualResourceId
    where bm.IsProcessing = 1 
	and bm.IsNewResource = 1
    AND bm.NewStartDate < @endTime 
	AND bm.NewEndDate >= @startTime
-- get total row number
declare @totalRows int = 0
select @totalRows = (select count(r.id)
			from Reservations r
			inner join Resources rc on r.RessourceId = rc.id
			left join @resourceIdsTbl rbl on rc.id = rbl.id
			left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
			--base condition
			where r.Active <> 0
				AND r.isrecurring <> 2 
				AND r.BusyStatus ='BUSY'
				--condition for recurring
				and (r.ParentReservationId is null or r.ParentReservationId <> 0)
				--additional condition
				AND r.StartDate >= Dateadd(day, -20, @startTime) 
				--current date condition
				AND r.StartDate < @endTime 
				AND r.EndDate > @startTime
				--booking manager active condition
				AND r.BookingManagerActive = 1
				AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
				AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
			)
			+ -- select booking manager inactive reservation
			(select count(A.id)
				from 
				(	select 
					distinct 
						r.id
					from BookingManagerMessage bm
					inner join Reservations r on bm.GlobalId = r.GlobalID
					inner join Resources rc on bm.ResourceId = rc.id
					left join @resourceIdsTbl rbl on rc.id = rbl.id
					left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
					left join @childResources cr on bm.ResourceId = cr.id
					where bm.IsProcessing = 1
						and bm.IsNewResource = 1
						--condition for recurring
						and (r.ParentReservationId is null or r.ParentReservationId <> 0)
						--additional condition
						AND r.StartDate >= Dateadd(day, -20, @startTime) 
						--base condition
						AND r.Active <> 0
						AND r.isrecurring <> 2 
						AND r.BusyStatus ='BUSY'
						--current date condition
						AND bm.NewStartDate < @endTime 
						AND bm.NewEndDate > @startTime
						--booking manager active condition
						AND r.BookingManagerActive = 0
						AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
						AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
						AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
						AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
						AND cr.id is null
				)A
			)
-- start select data
select top (@pageSize)
	B.id,
	B.Subject,
	B.StartDate,
	B.EndDate,
	B.Organizer,
	B.ResourceName,
	B.LocationPath,
	B.IsRecurring,
	B.OrganizerName,
	B.IsActive,
	B.CommonFormId,
	@totalRows as TotalRows
from
(
select 
	ROW_NUMBER() over(order by A.StartDate, A.EndDate) as rNumber,
	A.id,
	A.Subject,
	A.StartDate,
	A.EndDate,
	A.Organizer,
	A.ResourceName,
	A.LocationPath,
	A.IsRecurring,
	A.OrganizerName,
	A.IsActive,
	A.CommonFormId
	from
	(
		-- select booking manager active reservation
		-- select booking manager active reservation
		select 
			r.id,
			r.Subject,
			r.StartDate,
			r.EndDate,
			Isnull(r.organizeremail + ' (' 
										  + r.organizername + ')', r.organizeremail) AS Organizer,
			rc.Name as ResourceName,
			rc.LocationPath,
			r.IsRecurring,
			(SELECT top 1 pv.valuetext 
			FROM   dbo.propertytypes AS pt 
			INNER JOIN dbo.propertyvalues AS pv 
				ON pt.id = pv.propertyid 
				AND pt.name = 'RC_OrganizerName' 
				AND r.id = pv.reservationid)  
			AS OrganizerName,
			rc.SortOrder,
			1 as IsActive,
			rc.CommonFormId
		from Reservations r
		inner join Resources rc on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--condition for recurring
			and (r.ParentReservationId is null or r.ParentReservationId <> 0)
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))

		union all
		-- select booking manager inactive reservation
		select 
			BmTemp.id,
			BmTemp.Subject,
			BmTemp.StartDate,
			BmTemp.EndDate,
			BmTemp.Organizer,
			BmTemp.ResourceName,
			BmTemp.LocationPath,
			BmTemp.IsRecurring,
			BmTemp.OrganizerName,
			BmTemp.SortOrder,
			0 as IsActive,
			BmTemp.CommonFormId
		from
			(select 
				ROW_NUMBER() over (partition by r.GlobalID, bm.ResourceId order by r.id asc) as num,
				r.id,
				r.Subject,
				bm.NewStartDate as StartDate,
				bm.NewEndDate as EndDate,
				Isnull(r.organizeremail + ' (' 
											  + r.organizername + ')', r.organizeremail) AS Organizer,
				rc.Name as ResourceName,
				rc.LocationPath,
				r.IsRecurring,
				(SELECT top 1 pv.valuetext 
				FROM   dbo.propertytypes AS pt 
				INNER JOIN dbo.propertyvalues AS pv 
					ON pt.id = pv.propertyid 
					AND pt.name = 'RC_OrganizerName' 
					AND r.id = pv.reservationid)  
				AS OrganizerName,
				rc.SortOrder,
				rc.CommonFormId
			from BookingManagerMessage bm
				inner join Reservations r on bm.GlobalId = r.GlobalID
				inner join Resources rc on bm.ResourceId = rc.id
				left join @resourceIdsTbl rbl on rc.id = rbl.id
				left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
				left join @childResources cr on bm.ResourceId = cr.id
				where bm.IsProcessing = 1
					and bm.IsNewResource = 1
					--condition for recurring
					and (r.ParentReservationId is null or r.ParentReservationId <> 0)
					--additional condition
					AND r.StartDate >= Dateadd(day, -20, @startTime) 
					--base condition
					AND r.Active <> 0
					AND r.isrecurring <> 2 
					AND r.BusyStatus ='BUSY'
					--current date condition
					AND bm.NewStartDate < @endTime 
					AND bm.NewEndDate > @startTime
					--booking manager active condition
					AND r.BookingManagerActive = 0
					AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
					AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
					AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
					AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
					AND cr.id is null
				) BmTemp where BmTemp.num = 1
	) A
)B where B.rNumber > @skip
END
GO
-- create procedure GetListResourceHasReservationPaging --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListResourceHasReservationPaging]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListResourceHasReservationPaging]
GO
CREATE procedure [dbo].[GetListResourceHasReservationPaging]
@startTime datetime = null,
@endTime datetime = null,
@groupId int = null,
@resourceIds nvarchar(max) = null,
@locationIds nvarchar(max) = null,
@organizerMail nvarchar(max) = null,
@skip int = 0,
@pageSize int = 50
as
begin
	-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Data from [dbo].[udfSplitString](@resourceIds, ',')
-- split location ids list string into table
declare @locationIdsTbl table (id nvarchar(256))
insert into @locationIdsTbl
select Item from udfSplitStringV2(@locationIds, ',')
-- get total row number
declare @totalRows int = 0
select @totalRows = count(A.ResourceId) from (
	select distinct
			rc.id as ResourceId
		from Resources rc
		inner join Reservations r on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where (r.Active <> 0 OR isnull(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, '') = '' OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
	 union all
	 select distinct
			rc.id as ResourceId
		from BookingManagerMessage bm
		inner join Reservations r on bm.GlobalId = r.GlobalID
		inner join Resources rc on bm.ResourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		where bm.IsProcessing = 1
			and bm.IsNewResource = 1
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--base condition
			AND r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 0
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
) A
 --start select data
select top (@pageSize) 
	B.ResourceId,
	B.ResourceName,
	B.StartTime,
	B.EndTime,
	B.CommonFormId,
	B.AllowConflictMeeting,
	B.AutoAcceptAgent, 
	@totalRows as TotalRows 
from 
(
	select distinct
		ROW_NUMBER() over(order by A.SortOrder, A.ResourceName) as rNumber,
		A.ResourceId,
		A.ResourceName,
		A.StartTime,
		A.EndTime,
		A.SortOrder,
		A.CommonFormId,
		A.AllowConflictMeeting,
		A.AutoAcceptAgent
	from
	(
		-- select booking manager active reservation
		select distinct
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from Resources rc
		inner join Reservations r on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where rc.Visible = 1
			AND (r.Active <> 0 OR isnull(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union all
		-- select booking manager inactive reservation
		select distinct
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from BookingManagerMessage bm
		inner join Reservations r on bm.GlobalId = r.GlobalID
		inner join Resources rc on bm.ResourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		where rc.Visible = 1
			AND bm.IsProcessing = 1
			and bm.IsNewResource = 1
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--base condition
			AND r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--current date condition
			AND bm.NewStartDate < @endTime 
			AND bm.NewEndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 0
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
	) A
) B 
where B.rNumber > @skip
end 
GO
-- create procedure GetListVisibleResourcePaging --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListVisibleResourcePaging]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListVisibleResourcePaging]
GO
CREATE procedure [dbo].[GetListVisibleResourcePaging]
@groupId int = null,
@resourceIds nvarchar(max) = null,
@locationIds nvarchar(max) = null,
@skip int = 0,
@pageSize int = 50
as
begin
	-- split resource ids list string into table
	declare @resourceIdsTbl table (id nvarchar(256))
	insert into @resourceIdsTbl
	select Data from [dbo].[udfSplitString](@resourceIds, ',')
	-- split location ids list string into table
	declare @locationIdsTbl table (id nvarchar(256))
	insert into @locationIdsTbl
	select Item from udfSplitStringV2(@locationIds, ',')
	-- get total row number
	declare @totalRows int = 0
	select @totalRows = count(rc.id) from Resources rc
			left join @resourceIdsTbl rbl on rc.id = rbl.id
			left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
			--base condition
			where rc.Visible = 1
				AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
	-- start select data
	select top (@pageSize) 
		B.ResourceId,
		B.ResourceName,
		B.StartTime,
		B.EndTime,
		B.CommonFormId,
		B.AllowConflictMeeting,
		B.AutoAcceptAgent, 
		@totalRows as TotalRows 
	from 
	(
		-- select booking manager active reservation
		select distinct
			ROW_NUMBER() over(order by rc.SortOrder, rc.Name) as rNumber,
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from Resources rc
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where rc.Visible = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
	) B 
	where B.rNumber > @skip
end 
GO
-- create procedure GetReservationBookingManagerCalendarView --------
 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetReservationBookingManagerCalendarView]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetReservationBookingManagerCalendarView]
GO
CREATE procedure [dbo].[GetReservationBookingManagerCalendarView]
@startTime datetime = null,
@endTime datetime = null,
@groupId int = null,
@resourceIds nvarchar(max) = null,
@organizerMail nvarchar(max) = null
as
begin
-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Item from udfSplitStringV2(@resourceIds, ',')
-- start select data
select 
	A.id,
	A.ResourceId,
	A.Subject,
	A.StartDate,
	A.EndDate,
	A.OrganizerEmail,
	A.OrganizerName,
	A.IsActive,
	A.VRReservationId,
	A.ParentResourceIds
	from
	(
		-- select booking manager active reservation
		select distinct
			CONVERT(varchar, r.id) as id,
			r.RessourceId as ResourceId,
			r.Subject,
			r.StartDate,
			r.EndDate,
			r.OrganizerEmail,
			r.OrganizerName,
			1 as IsActive,
			ISNULL(r.VRReservationId, 0) AS VRReservationId,
			[dbo].[fn_Resource_GetVRStringIds](r.RessourceId) as ParentResourceIds
		from Reservations r
		left join ChildResources rc on r.RessourceId = rc.ChildResourceId
		left join @resourceIdsTbl rbl on r.RessourceId = rbl.id
		--base condition
		where (r.Active <> 0 OR ISNULL(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--condition for recurring
			and (r.ParentReservationId is null or r.ParentReservationId <> 0)
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union all
		-- select booking manager inactive reservation
		select distinct
			B.id,
			B.ResourceId as ResourceId,
			B.Subject,
			B.StartDate,
			B.EndDate,
			B.OrganizerEmail,
			B.OrganizerName,
			0 as IsActive,
			B.VRReservationId,
			B.ParentResourceIds
		from
		(
			select 
				ROW_NUMBER() over (partition by r.GlobalID, bm.ResourceId order by r.id asc) as num,
				ISNULL(CAST(r.id as varchar(10)),'')+'-'+ISNULL(CAST(bm.ResourceId as varchar(10)),'') as id,--concat(r.id, '-', bm.ResourceId) as id,
				bm.ResourceId as ResourceId,
				r.Subject,
				bm.NewStartDate as StartDate,
				bm.NewEndDate as EndDate,
				r.OrganizerEmail,
				r.OrganizerName,
				CASE WHEN r.VRReservationId is null THEN -1 ELSE r.VRReservationId END AS VRReservationId,
				[dbo].[fn_Resource_GetVRStringIds](bm.ResourceId) as ParentResourceIds
			from BookingManagerMessage bm
			inner join Reservations r on bm.GlobalId = r.GlobalID 
			left join ChildResources rc on r.RessourceId = rc.ChildResourceId
			left join @resourceIdsTbl rbl on bm.ResourceId = rbl.id
			where bm.IsProcessing = 1
				and bm.IsNewResource = 1
				--condition for recurring
				and (r.ParentReservationId is null or r.ParentReservationId <> 0)
				--additional condition
				AND r.StartDate >= Dateadd(day, -20, @startTime) 
				--base condition
				AND r.Active <> 0
				AND r.isrecurring <> 2 
				AND r.BusyStatus ='BUSY'
				--current date condition
				AND bm.NewStartDate < @endTime 
				AND bm.NewEndDate > @startTime
				--booking manager active condition
				AND r.BookingManagerActive = 0
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		)B where B.num = 1
	) A
end
GO
-- create function udfSplitStringV2 ---
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.udfSplitStringV2') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[udfSplitStringV2] 
END
GO
CREATE FUNCTION [dbo].[udfSplitStringV2]
(
   @List       NVARCHAR(MAX),
   @Delimiter  NVARCHAR(255)
)
RETURNS @Items TABLE (Item NVARCHAR(4000))
WITH SCHEMABINDING
AS
BEGIN
   DECLARE @ll INT = LEN(@List) + 1, @ld INT = LEN(@Delimiter);
 
   WITH a AS
   (
       SELECT
           [start] = 1,
           [end]   = COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, 1), 0), @ll),
           [value] = SUBSTRING(@List, 1, 
                     COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, 1), 0), @ll) - 1)
       UNION ALL
       SELECT
           [start] = CONVERT(INT, [end]) + @ld,
           [end]   = COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, [end] + @ld), 0), @ll),
           [value] = SUBSTRING(@List, [end] + @ld, 
                     COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, [end] + @ld), 0), @ll)-[end]-@ld)
       FROM a
       WHERE [end] < @ll
   )
   INSERT @Items SELECT [value]
   FROM a
   WHERE LEN([value]) > 0
   OPTION (MAXRECURSION 0);
 
   RETURN;
END
GO
IF NOT EXISTS (Select 1 FROM Icon Where IconKey = 'BookingManager')
INSERT INTO [dbo].[Icon]
           ([IconKey]
           ,[URL])
     VALUES
           ('BookingManager','../images/booking-manager.gif')
GO
Update Tree Set IconKey = 'BookingManager' Where [Key] = 'BookingManager'
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetConflictedReservationDates]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetConflictedReservationDates]
GO
CREATE PROCEDURE [dbo].[GetConflictedReservationDates]
@ResourceID int,
@startDate DateTime,
@endDate DateTime,
@startTime dateTime,
@endTime dateTime,
@localStartTime dateTime
AS
BEGIN
Declare @PreBuffer int
Declare @PostBuffer int
Declare @ConflictedReservation as int
Declare @BufferConflictedReservation as int
Declare @localStartDate as DateTime
Declare @localEndDate as DateTime
Declare @localPBStartDate as DateTime
Declare @localPBEndDate as DateTime
Declare @DateDifference Int
Declare @CurrentDateNew DateTime
SET @CurrentDateNew=@StartTime
Select @DateDifference = DATEDIFF(s,@startTime,@localStartTime)
DECLARE  @TempResourceReservations TABLE(StartDate datetime,ConflictedReservation int)
Select @PreBuffer = ISNULL(PreBufferTime,0), @PostBuffer = ISNULL(PostBufferTime,0) From Resources Where [Id] = @ResourceId
INSERT @TempResourceReservations(StartDate,ConflictedReservation)
Select distinct 
    CASE WHEN StartDate < @startDate Then @startDate ELSE PBStartDate End as StartDate
	, CASE WHEN 
		(
			( PBStartDate  between convert(datetime,@startTime,101) and convert(datetime,@endTime,101) ) Or
			( PBEndDate  between convert(datetime,@startTime,101) and convert(datetime,@endTime,101) )   Or
			( convert(datetime,@startTime,101) between PBStartDate and PBEndDate ) OR 
			( convert(datetime,@endTime,101) between PBStartDate  and PBEndDate )
		) Then 1 ELSE 0 END AS ConflictedReservation
	From  
	(		 
		SELECT  dbo.Reservations.id, 
			DATEADD(s,@DateDifference,Reservations.StartDate) AS StartDate, 
			DATEADD(s,@DateDifference,dbo.Reservations.EndDate) AS EndDate, 
			DATEADD(s,@DateDifference,DATEADD(MINUTE, - (1 *  CASE WHEN ISNULL(@PreBuffer, 0) <> 0 THEN @PreBuffer ELSE dbo.Resources.PreBufferTime END), dbo.Reservations.StartDate)) AS PBStartDate, 
			DATEADD(s,@DateDifference,DATEADD(MINUTE, CASE WHEN ISNULL(@PostBuffer, 0) <> 0 THEN @PostBuffer ELSE dbo.Resources.PostBufferTime END, dbo.Reservations.EndDate)) AS PBEndDate, 
			dbo.Reservations.BusyStatus, dbo.Reservations.RessourceId, dbo.Reservations.Name, dbo.Reservations.OrganizerEmail
		FROM dbo.Reservations 
			INNER JOIN dbo.Resources ON dbo.Reservations.RessourceId = Resources.ID
		WHERE dbo.Reservations.Active = 1 AND dbo.Reservations.IsRecurring <> 2
		AND 
		(
			dbo.Reservations.RessourceId = @ResourceID
			OR dbo.Reservations.RessourceId IN (Select VirtualResourceId From ChildResources Where ChildResourceId = @ResourceID)
			OR dbo.Reservations.RessourceId IN (select ChildResourceId from ChildResources  Where VirtualResourceId = @ResourceID)
			OR dbo.Reservations.RessourceId IN 
					(select cr2.VirtualResourceId from ChildResources cr1
						INNER JOIN ChildResources cr2 ON cr1.ChildResourceId = cr2.ChildResourceId
						Where cr1.VirtualResourceId <> cr2.VirtualResourceId AND cr1.VirtualResourceId = @ResourceID)
		)
		AND (dbo.Reservations.OrderStatus <> 'DELETED' OR dbo.Reservations.OrderStatus IS NULL) 
		AND dbo.Reservations.BusyStatus <> 'FREE' 
	) as VR
	WHERE 
	 (  
		PBStartDate >= convert(datetime,@startDate,101) And PBStartDate < convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBEndDate > convert(datetime,@startDate,101) And PBEndDate <= convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBStartDate <= convert(datetime,@startDate,101) 
		And 
		PBEndDate Between convert(datetime,@startDate,101) And convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBEndDate >= convert(datetime,@endDate,101)
        And 
        PBStartDate Between convert(datetime,@startDate,101) And convert(datetime,@endDate,101) 
     )
     OR 
     ( 
		PBStartDate <= convert(datetime,@startDate,101) And PBEndDate >= convert(datetime,@endDate,101)
     )	
Declare @ConflictCount as int
Select @ConflictCount = Count(*) From @TempResourceReservations TempResourceReservations Where ConflictedReservation = 1 
IF ( @ConflictCount > 0 )
BEGIN
	SELECT StartDate From @TempResourceReservations TempResourceReservations Where ConflictedReservation = 1 
	RETURN 
END
END
GO
UPDATE [DBVersion] SET [Value] = '3.8.0004.0029' WHERE [Property]='dbVersion'
GO